unit Ledlp_4a;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Ledlp;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    LEdit1: TLEdit;
    BitBtn1: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn2: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
{    procedure LEdit1Paint(Sender: TObject; DCHandle: Integer; ClientArea: TRect);}
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LEdit1Paint(Sender: TObject; DCHandle: TCanvas;
      ClientArea: TRect);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
const
  SunLocked: boolean = FALSE;
  XSun: longint = 0;
  YSun: longint = 1;

var
  XScreen,
  YScreen: longint;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.LEdit1Paint(Sender: TObject; DCHandle: TCanvas;
  ClientArea: TRect);
var
  Brush: hBrush;
  Pen: hPen;
  X,Y: longint;
begin
  { Fill background }
  DCHandle.Brush.Color := clBtnFace;
  DCHandle.FillRect(ClientArea);

  if SunLocked then
  begin
    { Retrieve info on scrolling position }
    Y := LEdit1.FirstVisibleLine - YSun;
    X := LEdit1.FirstVisiblePos - XSun;
    X := X * LEdit1.UnitsHorizontal;
    Y := Y * LEdit1.UnitsVertical;

    { Truncate values to 16-bit if they are large }
    if X > XScreen then
      X := XScreen;
    if X < - XScreen then
      X := -XScreen;
    if Y > YScreen then
      Y := YScreen;
    if Y < - YScreen then
      Y := -YScreen;

    { Move ellipse rectangle according to scrolling }
    OffsetRect(ClientArea, -X, -Y);
  end;

  { Draw ellipse }
  DCHandle.Brush.Style := bsSolid;
  DCHandle.Brush.Color := clRed;
  DCHandle.Ellipse(ClientArea.Left, ClientArea.Top, ClientArea.Right, ClientArea.Bottom);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  if SunLocked then
  begin
    BitBtn2.Caption := 'Lock';
    { Redraw window }
    LEdit1.Invalidate;
  end
  else
  begin
    BitBtn2.Caption := 'Unlock';
    { Store the place where Sun is locked }
    YSun := LEdit1.FirstVisibleLine;
    XSun := LEdit1.FirstVisiblePos;
  end;
  SunLocked := NOT SunLocked;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  LEdit1.PaintMode := dsDirect;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  LEdit1.PaintMode := dsUseMemoryDC;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  LEdit1.LoadFromFile('ledlp.txt');
{  LEdit1.LoadFromFile('d:\temp\zzz.txt');}
  { Set constants }
  XScreen := GetSystemMetrics(SM_CXSCREEN);
  YScreen := GetSystemMetrics(SM_CYSCREEN);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  SunLocked := False;
end;

end.
